ON INIT {
 SET given 0 // returns player has given authorisation to Polsius
 SET door_opened 0
 SET zuk_dead 0
 SET cowardice 20
 SET talked 0 // Used to check if Polsius has already talked to the player
 SET friend "NOFRIEND"
 ACCEPT
}

ON INITEND {
 LOADANIM ACTION1 "goblin_polsius_to_porticulis"
 LOADANIM ACTION2 "goblin_polsius_porticulis_talkm"
 TWEAK head "goblin_nohelm"
 TWEAK SKIN "NPC_GOBLIN_NOHELM_HEAD" "NPC_GOBLIN_NOHELM_HEAD_POLS"
 SET_NPC_STAT life 1
 SETWEAPON NONE
 SET reflection_mode 0
 TIMERmisc_reflection OFF
 ACCEPT
}

ON RELOAD {
 IF (#POLSIUS_TAVERN == 1) DESTROY ME
 TIMERbustingballs -i 0 15 GOTO ANNOY_ZUK
 ACCEPT
}

ON COLLIDE_NPC {
 REFUSE
}

ON CUSTOM {
  IF (^$PARAM1 == "STOP_BUSTING_BALLS") {
    TIMERbustingballs OFF
    ACCEPT
  }
  IF (^$PARAM1 == "ZUK_DEAD" ) {
    TIMERbustingballs OFF
    SET chatpos 1 
    SET zuk_dead 1
    IF (targ == 2) ACCEPT
    SET_CONTROLLED_ZONE POLSIUS_CELL
    ACCEPT
  }
  IF (^$PARAM1 == "HIT") {
    TIMERencourage -m 1 100 SPEAK [Polsius_kill_bastard] NOP
    ACCEPT
  }
  IF (^$PARAM1 == "CLOSE") {
    SET door_opened 0
    ACCEPT
  }
  IF (^$PARAM1 == "OPEN") {
    IF (talked == 1) ACCEPT
    IF (enemy == 1) {
     SENDEVENT ATTACK_PLAYER SELF ""
     ACCEPT
    }
    TIMERnag_player OFF
    SET talked 1
    SET door_opened 1
    IF (zuk_dead == 0) {
      SET #POLSIUS_TAVERN 1
      TIMERbustingballs OFF
      SETEVENT CHAT OFF
      SETEVENT COMBINE OFF
      BEHAVIOR MOVE_TO
      SETMOVEMODE RUN
      SETTARGET MARKER_0704  // flee if the cell is open and Zuk is not dead
      SPEAK [Polsius_going_tavern] SET targ 2
      ACCEPT
    }
>>GOING_TO_TAVERN
    SET_PLAYER_CONTROLS OFF
    TELEPORT -p MARKER_0491
    CINEMASCOPE -s ON
    PLAYER_INTERFACE -s HIDE
    BEHAVIOR FRIENDLY
    SETTARGET PLAYER
    TIMERlookat -m 1 10 PLAYERLOOKAT SELF
    IF (given == 0) {
      SPEAK -o [Polsius_going_tavern] GOTO DISAPPEAR
      ACCEPT
    }
   SET #POLSIUS_SIGNED 1
   INVENTORY PLAYERADD "\\quest_item\\signed_form\\signed_form"
   PLAY SYSTEM
   HEROSAY [system_object_received]
   SPEAK -o [Polsius_going_tavern_form] GOTO DISAPPEAR
   ACCEPT
  }
 ACCEPT
}

ON REACHEDTARGET {
  IF (^TARGET == MARKER_0704) {
    SETTARGET MARKER_0110
    ACCEPT
  }
  IF (^TARGET == MARKER_0110) {
    SETTARGET MARKER_0495
    ACCEPT
  }
  IF (^TARGET == MARKER_0495) {
    SETTARGET MARKER_0811
    ACCEPT
  }
  IF (^TARGET == MARKER_0811) {
    OBJECT_HIDE SELF ON
    TIMERtav 1 3 DESTROY ME
    ACCEPT
  }
 ACCEPT
}

ON CONTROLLEDZONE_ENTER {
 IF (^$param1 != PLAYER) ACCEPT
 UNSET_CONTROLLED_ZONE POLSIUS_CELL
 TIMERnag_player 0 15 GOTO NAGPLAYER
 ACCEPT
}

ON COMBINE {
  IF (^SPEAKING == 1) {
    SPEAK -p [player_not_now] NOP
    ACCEPT
  }
  IF (given == 1) ACCEPT
  IF (zuk_dead == 0) ACCEPT
  IF (^$PARAM1 ISCLASS "BLANK_FORM" ) {
    SENDEVENT CUSTOM ^$PARAM1 "SIGN"
    SET given 1
    TIMERnag_player OFF
    INVENTORY ADD "\\quest_item\\signed_form\\signed_form" //in case the player kills him before he open portcullis
    TIMER 1 2 GOTO dialogue3_1
    ACCEPT
  }
 ACCEPT
}

ON CHAT {
  IF (enemy == 1) ACCEPT
  IF (^SPEAKING == 1) ACCEPT
  IF (chatpos == 1) GOTO dialogue1_1
  IF (chatpos == 2) {
    IF (#need_form == 1) GOTO dialogue2_1
    GOSUB START_CHAT
    SPEAK [Polsius_iwillhelp] GOSUB END_CHAT
    ACCEPT   
  }        
  IF (chatpos == 3) {
    IF (given == 1) GOTO dialogue3_2
    GOSUB START_CHAT
    SPEAK [Polsius_blank_insist] GOSUB END_CHAT
    ACCEPT   
  }    
 ACCEPT
}

ON DIE
 SET #POLSIUS_TAVERN 2
 ACCEPT
}

>>dialogue1_1
 TIMERnag_player OFF
 UNSET_CONTROLLED_ZONE POLSIUS_CELL
 SET_PLAYER_CONTROLS OFF
 CINEMASCOPE -s ON
 PLAYER_INTERFACE -s HIDE
 PLAYER_LOOKAT SELF
 PLAYANIM -e ACTION1 PLAYANIM -le ACTION2
 SET frozen 1
 SPEAK -p [player_whoareyou] GOTO dialogue1_2
 ACCEPT

>>dialogue1_2
 SETNAME [description_polsius]
 SPEAK [Polsius_mepolsius] GOTO dialogue1_3
 ACCEPT

>>dialogue1_3
 SPEAK -p [player_whatwillyou] GOTO dialogue1_4
 ACCEPT

>>dialogue1_4
 SET chatpos 2
 SPEAK [Polsius_iwillhelp] GOTO GIVE_PLAYER_CONTROLS
 ACCEPT

>>dialogue2_1
 SPEAK -p [player_can_you_sign] GOTO dialogue2_2
 ACCEPT

>>dialogue2_2
 SPEAK [Polsius_give_me_blank]  SET chatpos 3
 ACCEPT

>>dialogue3_1
 SET chatpos 3
 SPEAK -p [player_hey_give_me_misc] GOTO dialogue3_2
 ACCEPT

>>dialogue3_2
 SPEAK [Polsius_no_no_misc] NOP
 ACCEPT

>>ANNOY_ZUK
 IF (#SHUT_UP == 1) ACCEPT
 SPEAK [Polsius_request_zuk] SENDEVENT CUSTOM Goblin_BASE_0049 "TALK"
 ACCEPT

>>DISAPPEAR
 SET #POLSIUS_TAVERN 1
 TIMERzboub 1 2 WORLDFADE IN 1000
 TIMERpouet 1 1 OBJECT_HIDE SELF YES GOTO GIVE_PLAYER_CONTROLS
 WORLDFADE OUT 1000 0 0 0
 TIMERdie 1 3 DESTROY ME
 ACCEPT

>>NAGPLAYER
 IF (^SPEAKING == 1) ACCEPT
 SPEAK [Polsius_come] NOP
 ACCEPT

>>GIVE_PLAYER_CONTROLS
 PLAYANIM WAIT
 SET frozen 0
 CINEMASCOPE -s OFF
 PLAYER_INTERFACE -s SHOW
 SET_PLAYER_CONTROLS ON
 ACCEPT

//#behavior

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE START ----------------------------------------------------------
// ---------------------------------------------------------------------------------
>>CLEAR_MICE_TARGET
 // if we care about mice : clear current mice target and listen to other mice
 IF ( care_about_mice == 1 )
 {
  SET targeted_mice "NOMOUSE"
  SETGROUP MICECARE // listen to other mice
 }
RETURN

>>SAVE_BEHAVIOR
 TIMERcolplayer OFF 
// to avoid TIMERcolplayer to restore the behavior 1 sec later
 IF (main_behavior_stacked == 0) 
 {
  IF (frozen == 1)
  { 
// frozen anim -> wake up !
    SET frozen 0
    PLAYANIM NONE
    PLAYANIM -2 NONE
    PHYSICAL ON
    COLLISION ON
    BEHAVIOR FRIENDLY
    SETTARGET PLAYER
  }
  SET main_behavior_stacked 1
  HEROSAY -d "STACK"
  BEHAVIOR STACK
 }
 ELSE
 { // behavior already saved : clear mice target if one
  GOSUB CLEAR_MICE_TARGET
 }
RETURN

>>RESTORE_BEHAVIOR
 IF (main_behavior_stacked == 1) 
 {
  GOSUB CLEAR_MICE_TARGET
  HEROSAY -d "UNSTACK"
  BEHAVIOR UNSTACK
  SET main_behavior_stacked 0
  RETURN
 }
IF (init_marker != "NONE")
  { 
   BEHAVIOR MOVE_TO
   SETTARGET -a ~init_marker~
   SETMOVEMODE WALK
   RETURN
  }
HEROSAY -d "go_home"
BEHAVIOR GO_HOME
SETTARGET PLAYER
RETURN

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE END ------------------------------------------------------------
// ---------------------------------------------------------------------------------

//#
//#LocalChat
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE START ---------------------------------------------------------
// ---------------------------------------------------------------------------------
>>START_CHAT
 // save misc reflection mode
 SET saved_reflection reflection_mode
 // no more stupid reflections !
 SET reflection_mode 0
 // fo not change behavior if frozen
 IF ( frozen == 1 ) RETURN
 // save behavior (if not saved)
 GOSUB SAVE_BEHAVIOR
 // look at player
 BEHAVIOR FRIENDLY
 SETTARGET PLAYER
RETURN

>>END_CHAT
 SET_EVENT COLLIDE_NPC ON
 SET collided_player 0
 // restor behavior only if not in fighting mode
 IF ( fighting_mode == 0 )
 {
  // restore misc reflection mode
  SET reflection_mode saved_reflection
  // if frozen : don't restore behavior
  IF ( frozen == 1 ) RETURN
  // restore behavior
  GOSUB RESTORE_BEHAVIOR
 }
RETURN
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE END -----------------------------------------------------------
// ---------------------------------------------------------------------------------

//#
