ON INIT {
 SET friend "kingdom"
 INVENTORY ADD "MAGIC\\POTION_MANA\\POTION_MANA"
 INVENTORY ADD "MAGIC\\POTION_MANA\\POTION_MANA"
 INVENTORY ADD "JEWELRY\\GOLD_RING\\GOLD_RING"
 INVENTORY ADD "ARMOR\\CHEST_LEATHERAC\\CHEST_LEATHERAC"
 INVENTORY ADD "ARMOR\\LEGGINGS_LEATHERAC\\LEGGINGS_LEATHERAC"
 INVENTORY ADD "magic\\scroll_generic\\scroll_generic"
 SENDEVENT -ir TRANSMUTE 1 "8 SPEED"
 INVENTORY ADD_FROM_SCENE "KEY_BASE_0024"
 SET carlo_rituals 0  // Carlo has talked about rituals
 SET reflection_mode 0
 SET disappeared 0  // Used to know if player has attacked npc
 SET goenemy 0   // Used to check if player can be ennemy with the kingdom
 ACCEPT
}

ON INITEND {
 SET_NPC_STAT life 1000
 TWEAK HEAD "human_priest_naked_head"
 TWEAK SKIN "npc_Human_priest_akbaa_body" "npc_Human_priest_suiberis_body"
 TWEAK SKIN "npc_Human_priest_akbaa_head" "npc_Human_priest_suiberis_head"
 BEHAVIOR WANDER_AROUND 200
 SETTARGET NONE
 ACCEPT
}

ON LOAD {
 USE_MESH "HUMAN_PRIEST\HUMAN_PRIEST.TEO"
 ACCEPT
}

ON REACHEDTARGET {
  IF (^TARGET == MARKER_0892) {
    FORCE_ANGLE 270
    BEHAVIOR NONE
    SETTARGET NONE
    TIMERmap 1 30 GOTO AWAY
    ACCEPT
  }
 ACCEPT
}

>>AWAY
 FORCE_ANGLE 180
 BEHAVIOR WANDER_AROUND 400
 SETTARGET NONE
 TIMERmapbis 1 30 GOTO LOOK_MAP
 ACCEPT

//#behavior

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE START ----------------------------------------------------------
// ---------------------------------------------------------------------------------
>>CLEAR_MICE_TARGET
 // if we care about mice : clear current mice target and listen to other mice
 IF ( care_about_mice == 1 )
 {
  SET targeted_mice "NOMOUSE"
  SETGROUP MICECARE // listen to other mice
 }
RETURN

>>SAVE_BEHAVIOR
 TIMERcolplayer OFF 
// to avoid TIMERcolplayer to restore the behavior 1 sec later
 IF (main_behavior_stacked == 0) 
 {
  IF (frozen == 1)
  { 
// frozen anim -> wake up !
    SET frozen 0
    PLAYANIM NONE
    PLAYANIM -2 NONE
    PHYSICAL ON
    COLLISION ON
    BEHAVIOR FRIENDLY
    SETTARGET PLAYER
  }
  SET main_behavior_stacked 1
  HEROSAY -d "STACK"
  BEHAVIOR STACK
 }
 ELSE
 { // behavior already saved : clear mice target if one
  GOSUB CLEAR_MICE_TARGET
 }
RETURN

>>RESTORE_BEHAVIOR
 IF (main_behavior_stacked == 1) 
 {
  GOSUB CLEAR_MICE_TARGET
  HEROSAY -d "UNSTACK"
  BEHAVIOR UNSTACK
  SET main_behavior_stacked 0
  RETURN
 }
IF (init_marker != "NONE")
  { 
   BEHAVIOR MOVE_TO
   SETTARGET -a ~init_marker~
   SETMOVEMODE WALK
   RETURN
  }
HEROSAY -d "go_home"
BEHAVIOR GO_HOME
SETTARGET PLAYER
RETURN

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE END ------------------------------------------------------------
// ---------------------------------------------------------------------------------

//#
//#LocalChat
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE START ---------------------------------------------------------
// ---------------------------------------------------------------------------------
>>START_CHAT
 // save misc reflection mode
 SET saved_reflection reflection_mode
 // no more stupid reflections !
 SET reflection_mode 0
 // fo not change behavior if frozen
 IF ( frozen == 1 ) RETURN
 // save behavior (if not saved)
 GOSUB SAVE_BEHAVIOR
 // look at player
 BEHAVIOR FRIENDLY
 SETTARGET PLAYER
RETURN

>>END_CHAT
 SET_EVENT COLLIDE_NPC ON
 SET collided_player 0
 // restor behavior only if not in fighting mode
 IF ( fighting_mode == 0 )
 {
  // restore misc reflection mode
  SET reflection_mode saved_reflection
  // if frozen : don't restore behavior
  IF ( frozen == 1 ) RETURN
  // restore behavior
  GOSUB RESTORE_BEHAVIOR
 }
RETURN
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE END -----------------------------------------------------------
// ---------------------------------------------------------------------------------

//#

ON CHAT {
  IF (enemy == 1) ACCEPT
  IF (^SPEAKING == 1) ACCEPT
  IF (chatpos == 1) GOTO DIALOGUE1_1
  IF (chatpos == 0) {
    GOSUB START_CHAT
    SETNAME [description_suiberis]
    SPEAK [suiberis_greetings_player] GOSUB END_CHAT
    SET chatpos 1 
    ACCEPT
  }
  IF (chatpos == 2) {
    SPEAK -p [player_observing_misc] SPEAK [suiberis_nothing_misc] NOP
    ACCEPT
  }
 ACCEPT
}

ON CUSTOM {
  IF (^$PARAM1 == "THIEF") {
    TIMERmap OFF
    TIMERmapbis OFF
    IF (PLAYER_IN_SIGHT == 0) ACCEPT
    SENDEVENT ATTACK_PLAYER SELF ""
    ACCEPT
  }
  IF (^$PARAM1 == "OK") {
    SET goenemy 1
    ACCEPT
  }
 ACCEPT
}

ON AGGRESSION {
 IF (disappeared == 1) REFUSE
 SETEVENT COLLIDE_NPC OFF
 TIMERmap OFF
 TIMERmapbis OFF
 SET disappeared 1
 INVULNERABILITY ON 
 BEHAVIOR MOVE_TO
 SETTARGET MARKER_0916
 SETMOVEMODE RUN
 TIMERbob 1 3 SPELLCAST -smf 10 INVISIBILITY human_base_0079
 TIMERdead 1 4 GOTO LA_SUITE
 REFUSE
}

>>LA_SUITE
 TELEPORT MARKER_0921
 BEHAVIOR NONE
 SETTARGET NONE
 IF (goenemy == 0) SET #KINGDOM_ENEMY 1
 DESTROY SELF
 ACCEPT

ON CHANGESTATUS {
  IF (^$PARAM1 == "5") {
    TIMERmap OFF
    TIMERmapbis OFF
    SENDEVENT CUSTOM PUBLIC_NOTICE_0015 "HIDE"
    SENDEVENT CUSTOM LIGHT_DOOR_0086 "UNLOCK"
    DESTROY SELF
    ACCEPT
  }
 ACCEPT
}

//  Dialogues  //

>>DIALOGUE1_1
 IF (#carlo_rituals == 1) GOTO DIALOGUE2_1
 SPEAK -p [player_observing_misc] SPEAK [suiberis_nothing_misc] GOTO LOOK_MAP
 ACCEPT

//  If carlos has talked about rituals.  //

>>DIALOGUE2_1
  IF (carlo_rituals == 0) {
    SET carlo_rituals 1
    TELEPORT MARKER_0855
    BEHAVIOR FRIENDLY
    SETTARGET PLAYER
    TELEPORT -p MARKER_0926
    SET_PLAYER_CONTROLS OFF
    CINEMASCOPE -s ON
    PLAYER_INTERFACE -s HIDE
    TIMERlookat -m 1 10 GOTO DIALOGUE2_1bis
    ACCEPT
  }
 SPEAK -p [player_observing_misc] SPEAK [suiberis_nothing_misc] NOP
 ACCEPT

>>DIALOGUE2_1bis
 PLAYERLOOKAT SELF
 SPEAK -pc ZOOM 180 200 180 200 180 180 [player_rituals_suiberis] GOTO DIALOGUE2_2
 ACCEPT

>>DIALOGUE2_2
 SPEAK -c SIDE_R PLAYER 10 100 90 90 0 [suiberis_dont_know_rituals] GOTO DIALOGUE2_3
 ACCEPT

>>DIALOGUE2_3
 SET chatpos 2
 CINEMASCOPE -s OFF
 PLAYER_INTERFACE -s SHOW
 SET_PLAYER_CONTROLS ON
>>LOOK_MAP
 BEHAVIOR MOVE_TO
 SETTARGET MARKER_0892
 ACCEPT
