// goblin warder in player's jail - Level 1

ON INIT {
 INVENTORY ADDFROMSCENE "NOTE_0003"
 INVENTORY ADD "PROVISIONS\\CARROT\\CARROT"
 SET tuto_fight 0
 SET reflection_mode 0
 SET panicmode 1
 SET cowardice 0
 SET player_out 0 // Returns player is still in cell (for distant attack from the player
 SET dead 0  // Returns goblin is dead - Used if player has escaped without killing it
 SET tutoinv 0
 SET tutrial_dead 0 // Used to check if tutorial dead has been played
 SET friend "NONE"
 SET key_carried "portcullis"
 ACCEPT
}

ON INITEND {
 SET_NPC_STAT life 9
 SET_NPC_STAT damages 3
 BEHAVIOR NONE
 SETTARGET NONE
 OBJECT_HIDE SELF ON
 SET_WEAPON NONE
 SET_CONTROLLED_ZONE CELL_1
 SET_CONTROLLED_ZONE CELL_2
 ACCEPT
}

ON UNDETECTPLAYER {
 IF (enemy == 1) REFUSE
 ACCEPT
}

ON RELOAD {
 IF (dead == 1) ACCEPT
 SET dead 1
 SET dying []
 SET friend "NONE"
 FORCEDEATH ME
 ACCEPT
}

ON INVENTORY2_OPEN {
 IF (tutoinv == 1) ACCEPT
 SET tutoinv 1
 HEROSAY [system_tutorial_4_new]
 QUEST [system_tutorial_4_new]
 ACCEPT
}

ON REACHEDTARGET {
  IF (^TARGET == MARKER_0258) {
    SENDEVENT CUSTOM LEVEL_0011 "OPEN"
    SENDEVENT ATTACK_PLAYER SELF ""
    SENDEVENT CUSTOM HUMAN_BASE_0028 "ATTACKING"
    ACCEPT
  }
  IF (^TARGET == MARKER_0150) {
    BEHAVIOR NONE
    SETTARGET NONE
    TIMERpatrol01 1 5 GOTO NEXT_STEP01
    ACCEPT
  }
  IF (^TARGET == MARKER_0111) {
    BEHAVIOR NONE
    SETTARGET NONE
    TIMERpatrol02 1 5 GOTO NEXT_STEP02
    ACCEPT
  }
 ACCEPT
}

>>NEXT_STEP01
  IF (main_behavior_stacked != 0) {
   BEHAVIOR NONE
   SETTARGET NONE
   TIMERpatrol01 1 4 GOTO NEXT_STEP01
  }
  ELSE {
    BEHAVIOR MOVE_TO
    SETTARGET MARKER_0111
  }
 ACCEPT

>>NEXT_STEP02
  IF (main_behavior_stacked != 0) {
   BEHAVIOR NONE
   SETTARGET NONE
   TIMERpatrol02 1 4 GOTO NEXT_STEP02
  }
  ELSE {
    BEHAVIOR MOVE_TO
    SETTARGET MARKER_0150
  }
 ACCEPT

ON AGGRESSION {
  IF (player_out == 0) {
    SENDEVENT CUSTOM HUMAN_BASE_0028 "HIT"
    BEHAVIOR MOVE_TO
    SETTARGET MARKER_0258
    ACCEPT
  }
 SENDEVENT CUSTOM HUMAN_BASE_0028 "HIT"
 ACCEPT
}

//#behavior

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE START ----------------------------------------------------------
// ---------------------------------------------------------------------------------
>>CLEAR_MICE_TARGET
 // if we care about mice : clear current mice target and listen to other mice
 IF ( care_about_mice == 1 )
 {
  SET targeted_mice "NOMOUSE"
  SETGROUP MICECARE // listen to other mice
 }
RETURN

>>SAVE_BEHAVIOR
 TIMERcolplayer OFF 
// to avoid TIMERcolplayer to restore the behavior 1 sec later
 IF (main_behavior_stacked == 0) 
 {
  IF (frozen == 1)
  { 
// frozen anim -> wake up !
    SET frozen 0
    PLAYANIM NONE
    PLAYANIM -2 NONE
    PHYSICAL ON
    COLLISION ON
    BEHAVIOR FRIENDLY
    SETTARGET PLAYER
  }
  SET main_behavior_stacked 1
  HEROSAY -d "STACK"
  BEHAVIOR STACK
 }
 ELSE
 { // behavior already saved : clear mice target if one
  GOSUB CLEAR_MICE_TARGET
 }
RETURN

>>RESTORE_BEHAVIOR
 IF (main_behavior_stacked == 1) 
 {
  GOSUB CLEAR_MICE_TARGET
  HEROSAY -d "UNSTACK"
  BEHAVIOR UNSTACK
  SET main_behavior_stacked 0
  RETURN
 }
IF (init_marker != "NONE")
  { 
   BEHAVIOR MOVE_TO
   SETTARGET -a ~init_marker~
   SETMOVEMODE WALK
   RETURN
  }
HEROSAY -d "go_home"
BEHAVIOR GO_HOME
SETTARGET PLAYER
RETURN

// ---------------------------------------------------------------------------------
// BEHAVIOR INCLUDE END ------------------------------------------------------------
// ---------------------------------------------------------------------------------

//#
//#LocalChat
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE START ---------------------------------------------------------
// ---------------------------------------------------------------------------------
>>START_CHAT
 // save misc reflection mode
 SET saved_reflection reflection_mode
 // no more stupid reflections !
 SET reflection_mode 0
 // fo not change behavior if frozen
 IF ( frozen == 1 ) RETURN
 // save behavior (if not saved)
 GOSUB SAVE_BEHAVIOR
 // look at player
 BEHAVIOR FRIENDLY
 SETTARGET PLAYER
RETURN

>>END_CHAT
 SET_EVENT COLLIDE_NPC ON
 SET collided_player 0
 // restor behavior only if not in fighting mode
 IF ( fighting_mode == 0 )
 {
  // restore misc reflection mode
  SET reflection_mode saved_reflection
  // if frozen : don't restore behavior
  IF ( frozen == 1 ) RETURN
  // restore behavior
  GOSUB RESTORE_BEHAVIOR
 }
RETURN
// ---------------------------------------------------------------------------------
// LocalChat INCLUDE END -----------------------------------------------------------
// ---------------------------------------------------------------------------------

//#

ON CHAT {
 IF (enemy == 1) ACCEPT
 IF (^SPEAKING == 1) ACCEPT
 GOSUB START_CHAT
 SPEAK [Goblin_guard_toplayer] GOSUB END_CHAT
 ACCEPT
}

ON DIE {
  IF (dead == 1) {
    SENDEVENT CUSTOM HUMAN_BASE_0028 "DEAD"
    UNSET_CONTROLLED_ZONE CELL_1
    UNSET_CONTROLLED_ZONE CELL_2
    AMBIANCE -v 0 ambient_gob_jail_stress
    ACCEPT
  }
 SENDEVENT CUSTOM HUMAN_BASE_0028 "DEAD"
 UNSET_CONTROLLED_ZONE CELL_1
 UNSET_CONTROLLED_ZONE CELL_2
 AMBIANCE -v 0 ambient_gob_jail_stress
 SET dead 1
 //SENDEVENT BREAK bone_0001 ""
 TIMERtuto 1 2 GOTO TUTORIAL
 ACCEPT
}

>>TUTORIAL
 TIMERpouet 1 1 HALO -f
 HALO -os 60
 PLAY SYSTEM
 TIMERtut -m 1 500 HEROSAY [system_tutorial_4]
 QUEST [system_tutorial_4]
 ACCEPT

ON DETECTPLAYER {
 IF (enemy == 0) ACCEPT
 IF (tuto_fight == 1) ACCEPT
 SET tuto_fight 1
// TIMERtit 1 2 PLAY SYSTEM HEROSAY [system_tutorial_5bis]
 ACCEPT
}

ON CONTROLLEDZONE_ENTER {
  IF (^$PARAM2 == LEVEL1_ZONE1) {
    SET #GOB_JAIL_DEAD 1
    OBJECT_HIDE SELF ON
    FORCEDEATH ME    
    ACCEPT
  }
  IF (fighting_mode == 1) ACCEPT
  IF (^$PARAM2 == CELL_1) {
    IF (^$PARAM1 == PLAYER) {
      SET enemy 0
      SETEVENT HEAR OFF
      SETEVENT DETECTPLAYER OFF
      ACCEPT
    }
   ACCEPT
  }
  IF (^$PARAM1 == PLAYER) {
    SET enemy 1
    SETEVENT HEAR ON
    SETEVENT DETECTPLAYER ON
    ACCEPT
  }
 ACCEPT
}

ON CUSTOM {
  IF (^$PARAM1 == "PLAYER_OUT_CELL") {
    SET player_out 1
    ACCEPT
  }
  IF (^$PARAM1 == "PRISONER_CHATTING") {
    SPEAK -a [Goblin_guard_shutup] NOP
    ACCEPT
  }
  IF (^$PARAM1 == "DIE") {
    SET #GOB_JAIL_DEAD 1
    OBJECT_HIDE SELF ON
    FORCEDEATH ME    
    ACCEPT
  }
  IF (^$PARAM1 == "EXIT") {
    OBJECT_HIDE SELF OFF
    BEHAVIOR MOVE_TO
    SETTARGET MARKER_0150
    SENDEVENT JAIL_STONE_0003 CUSTOM "CHECK"
   ACCEPT
   }
  IF (^$PARAM1 == "UNHIDE") {
    OBJECT_HIDE SELF OFF
    TELEPORT MARKER_0111
    BEHAVIOR MOVE_TO
    SETTARGET MARKER_0150
    ACCEPT
  }
 ACCEPT
}

ON ACTIVATE_PHYSICS {
 ACTIVATE_PHYSICS
 ACCEPT
}
